/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;

public class XMLUtil {
    public static Document createXMLDocument(String xmlStr) throws Exception {
        if (xmlStr == null || xmlStr.isEmpty()) {
            throw new Exception("Invalid text stream for creating XML document.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(xmlStr.getBytes("UTF-8"));
        Document xmlDoc = builder.parse(is);
        ((InputStream)is).close();
        return xmlDoc;
    }

    public static XMLStreamWriter createXMLStreamWriter(ByteArrayOutputStream bos) throws Exception {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = xof.createXMLStreamWriter(bos, "UTF-8");
        return writer;
    }

    public static String readNodeInnerXml(XMLStreamReader reader, String parentNodeName) throws Exception {
        String innerXml = "";
        boolean parentNodeEnded = false;
        while (reader.hasNext() && !parentNodeEnded) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    String attrStr = "";
                    int attrCount = reader.getAttributeCount();
                    if (attrCount > 0) {
                        for (int i = 0; i < attrCount; ++i) {
                            String attrName = reader.getAttributeName(i).toString();
                            String attrValue = reader.getAttributeValue(i);
                            attrStr = attrStr + String.format(" %s=\"%s\"", attrName, attrValue);
                        }
                    }
                    innerXml = innerXml + String.format("<%s%s>", reader.getName().toString(), attrStr);
                    break;
                }
                case 4: {
                    innerXml = innerXml + reader.getText();
                    break;
                }
                case 2: {
                    String name = reader.getName().toString();
                    if (name.equalsIgnoreCase(parentNodeName)) {
                        parentNodeEnded = true;
                        break;
                    }
                    innerXml = innerXml + String.format("</%s>", reader.getName().toString());
                }
            }
        }
        return innerXml;
    }

    public static String readNodeOuterXML(XMLStreamReader reader, String nodeName) throws Exception {
        String innerXml = XMLUtil.readNodeInnerXml(reader, nodeName);
        return String.format("<%s>%s</%s>", nodeName, innerXml, nodeName);
    }
}

