/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Response;

import Zenoph.Notify.Build.Reader.MessageReportReader;
import Zenoph.Notify.Report.MessageReport;
import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Utils.MessageUtil;

public class MessageResponse
extends APIResponse {
    private static final String DATA_FRAGMENT_PATTERN = "<data>(.*)?<\\/data>";
    protected MessageReport _report;

    protected MessageResponse() {
    }

    public static MessageResponse create(APIResponse apiResp) throws Exception {
        MessageResponse msgResponse = new MessageResponse();
        msgResponse._httpStatusCode = apiResp.getHttpStatusCode();
        msgResponse._requestHandShake = apiResp.getRequestHandShake();
        String dataFragment = apiResp.getDataFragment();
        if (dataFragment != null && !dataFragment.isEmpty()) {
            if (!MessageResponse.isValidDataFragment(dataFragment)) {
                throw new Exception("Invalid response data fragment.");
            }
            msgResponse._report = MessageResponse.extractReport(dataFragment);
            msgResponse._dataFragment = null;
        }
        return msgResponse;
    }

    private static MessageReport extractReport(String dataFragment) throws Exception {
        MessageReportReader reportReader = new MessageReportReader();
        reportReader.setData(dataFragment);
        return reportReader.read();
    }

    public static boolean isValidDataFragment(String dataFragment) {
        return MessageUtil.isRegexMatch(String.format("%s%s%s", "^", DATA_FRAGMENT_PATTERN, "$"), dataFragment, true);
    }

    public MessageReport getReport() {
        return this._report;
    }
}

