/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Request;

import Zenoph.Notify.Collections.ComposerDestinationsList;
import Zenoph.Notify.Compose.Composer;
import Zenoph.Notify.Compose.IComposer;
import Zenoph.Notify.Enums.DestinationMode;
import Zenoph.Notify.Enums.MessageCategory;
import Zenoph.Notify.Enums.NumberAddInfo;
import Zenoph.Notify.Events.ISubmitCompletedListener;
import Zenoph.Notify.Events.ISubmitProgressListener;
import Zenoph.Notify.Request.NotifyRequest;
import Zenoph.Notify.Response.APIResponse;
import Zenoph.Notify.Store.AuthProfile;
import java.util.List;

abstract class ComposeRequest
extends NotifyRequest
implements IComposer {
    protected Composer _composer = null;
    protected static int GZBIN_DESTS_LEVEL = 50000;

    public ComposeRequest() {
    }

    public ComposeRequest(AuthProfile ap) throws Exception {
        super(ap);
    }

    @Override
    public void setAuthProfile(AuthProfile ap) throws Exception {
        this.validateAuthProfile(ap);
        if (this._composer == null) {
            throw new Exception("Composer object has not been initialised.");
        }
        this._composer.setUserData(ap.getUserData());
        super.setAuthProfile(ap);
    }

    protected APIResponse submit(ISubmitProgressListener spl, ISubmitCompletedListener scl) throws Exception {
        if (spl != null && scl != null) {
            this.addSubmitProgressListener(spl);
            this.addSubmitCompletedListener(scl);
        }
        APIResponse apiResp = this.submit();
        if (spl != null && scl != null) {
            this.removeSubmitProgressListener(spl);
            this.removeSubmitCompletedListener(scl);
        }
        return apiResp;
    }

    public Composer getComposer() {
        return this._composer;
    }

    protected void validate() throws Exception {
        this.assertComposer();
        if (this._composer.getDestinationsCount() == 0) {
            throw new Exception("There are no destinations for submitting message.");
        }
    }

    protected void assertComposer() throws Exception {
        if (this._composer == null) {
            throw new Exception("Invalid reference to message composer object.");
        }
    }

    @Override
    public String getDefaultNumberPrefix() throws Exception {
        this.assertComposer();
        return this._composer.getDefaultNumberPrefix();
    }

    @Override
    public void setDefaultNumberPrefix(String dialCode) throws Exception {
        this.assertComposer();
        this._composer.setDefaultNumberPrefix(dialCode);
    }

    @Override
    public List<String[]> getRouteCountries() throws Exception {
        this.assertComposer();
        return this._composer.getRouteCountries();
    }

    @Override
    public String getDestinationCountry(String phoneNumber) throws Exception {
        this.assertComposer();
        return this._composer.getDestinationCountry(phoneNumber);
    }

    @Override
    public String[] getDefaultDestinationCountry() throws Exception {
        this.assertComposer();
        return this._composer.getDefaultDestinationCountry();
    }

    @Override
    public DestinationMode getDestinationWriteMode(String phoneNumber) throws Exception {
        this.assertComposer();
        return this._composer.getDestinationWriteMode(phoneNumber);
    }

    @Override
    public DestinationMode getDestinationWriteModeById(String messageId) throws Exception {
        this.assertComposer();
        return this._composer.getDestinationWriteModeById(messageId);
    }

    @Override
    public String[] getDefaultTimeZone() throws Exception {
        this.assertComposer();
        return this._composer.getDefaultTimeZone();
    }

    @Override
    public ComposerDestinationsList getDestinations() throws Exception {
        this.assertComposer();
        return this._composer.getDestinations();
    }

    @Override
    public int getDestinationsCount() throws Exception {
        this.assertComposer();
        return this._composer.getDestinationsCount();
    }

    @Override
    public boolean updateDestination(String prePhoneNumber, String newPhoneNumber) throws Exception {
        this.assertComposer();
        return this._composer.updateDestination(prePhoneNumber, newPhoneNumber);
    }

    @Override
    public boolean updateDestinationById(String messageId, String newPhoneNumber) throws Exception {
        this.assertComposer();
        return this._composer.updateDestinationById(messageId, newPhoneNumber);
    }

    @Override
    public void clearDestinations() throws Exception {
        this.assertComposer();
        this._composer.clearDestinations();
    }

    @Override
    public int addDestinationsFromTextStream(String str) throws Exception {
        this.assertComposer();
        return this._composer.addDestinationsFromTextStream(str);
    }

    @Override
    public int addDestinationsFromCollection(String[] phoneNumbers) throws Exception {
        this.assertComposer();
        return this._composer.addDestinationsFromCollection(phoneNumbers);
    }

    @Override
    public int addDestinationsFromCollection(String[] phoneNumbers, boolean throwEx) throws Exception {
        this.assertComposer();
        return this._composer.addDestinationsFromCollection(phoneNumbers, throwEx);
    }

    @Override
    public int addDestinationsFromCollection(List<String> phoneNumbers) throws Exception {
        this.assertComposer();
        return this._composer.addDestinationsFromCollection(phoneNumbers);
    }

    @Override
    public int addDestinationsFromCollection(List<String> phoneNumbers, boolean throwEx) throws Exception {
        this.assertComposer();
        return this._composer.addDestinationsFromCollection(phoneNumbers, throwEx);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber) throws Exception {
        this.assertComposer();
        return this._composer.addDestination(phoneNumber);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx) throws Exception {
        this.assertComposer();
        return this._composer.addDestination(phoneNumber, throwEx);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, String messageId) throws Exception {
        this.assertComposer();
        return this._composer.addDestination(phoneNumber, messageId);
    }

    @Override
    public NumberAddInfo addDestination(String phoneNumber, boolean throwEx, String messageId) throws Exception {
        this.assertComposer();
        return this._composer.addDestination(phoneNumber, throwEx, messageId);
    }

    @Override
    public boolean removeDestination(String phoneNumber) throws Exception {
        this.assertComposer();
        return this._composer.removeDestination(phoneNumber);
    }

    @Override
    public boolean removeDestinationById(String messageId) throws Exception {
        this.assertComposer();
        return this._composer.removeDestinationById(messageId);
    }

    @Override
    public boolean destinationExists(String phoneNumber) throws Exception {
        this.assertComposer();
        return this._composer.destinationExists(phoneNumber);
    }

    @Override
    public MessageCategory getCategory() throws Exception {
        this.assertComposer();
        return this._composer.getCategory();
    }
}

