/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Enums;

import java.util.HashMap;

public enum DestinationMode {
    DM_NONE(0),
    DM_ADD(1),
    DM_UPDATE(2),
    DM_DELETE(3);

    private int _id = 0;
    private static final HashMap<Integer, DestinationMode> _modeIdMap;

    private DestinationMode(int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public static DestinationMode fromInt(int id) throws Exception {
        DestinationMode mode = _modeIdMap.get(id);
        if (mode == null) {
            throw new Exception("Invalid destination write mode identifier.");
        }
        return mode;
    }

    static {
        _modeIdMap = new HashMap();
        for (DestinationMode mode : DestinationMode.values()) {
            _modeIdMap.put(mode.getId(), mode);
        }
    }
}

