/*
 * Decompiled with CFR 0.152.
 */
package Zenoph.Notify.Build.Writer;

import Zenoph.Notify.Build.Writer.KeyValueDataWriter;
import Zenoph.Notify.Compose.VoiceComposer;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.UUID;

public final class MultiPartDataWriter
extends KeyValueDataWriter {
    private String _boundary = null;

    public MultiPartDataWriter() {
        String randomText = UUID.randomUUID().toString().replace("-", "");
        this._boundary = String.format("--------------------%s", randomText);
    }

    public String getDataBoundary() {
        return this._boundary;
    }

    @Override
    public void writeVoiceRequest(VoiceComposer vc, OutputStream os) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.writeVoiceMessageData(vc, sb);
        this.writeRequestData(sb.toString(), os);
        if (vc.isOfflineVoice()) {
            int bytesRead;
            String fileName = vc.getOfflineVoice();
            String fileKeyName = "voice_file";
            sb = new StringBuilder();
            sb.append(String.format("%s\n", this._boundary));
            sb.append(String.format("Content-Disposition: form-data; name=%s; filename=%s\n", fileKeyName, fileName));
            sb.append("Content-Type: application/octet-stream\n\n");
            this.writeRequestData(sb.toString(), os);
            FileInputStream fis = new FileInputStream(fileName);
            byte[] dataBuffer = new byte[262144];
            while ((bytesRead = fis.read(dataBuffer)) != -1) {
                os.write(dataBuffer, 0, bytesRead);
            }
        }
    }

    @Override
    protected void appendKeyValueData(StringBuilder sb, String key, String value) {
        sb.append(String.format("%s\n", this._boundary));
        sb.append(String.format("Content-Disposition: form-data; name=%s\n\n", key));
        sb.append(String.format("%s", value));
    }
}

